<?php
/*
Plugin Name: WAO Tiendas
Text Domain: wao-tiendas
Domain Path: /languages
Plugin URI: https://download.winandoffice.com/Install/Plugin%20Arturo
Description: Funciones exclusivas de las tiendas de Windows & Office..
Version: 2.5.31 (Permiso configuracion de supers. Nuevos shortcodes [hra] y [propietario]. Shortcodes en factura. -Traducciones. Creacion automatica de form y page support. Link contact support en email, *Verificar plugin paypal, *Widget ventas dia con monto )
Author: Arturo Zubieta
Author URI:https://winandoffice.com
License: GPL
*/
/*INDICE DEL Plugin
  =================
* AÑADIR LINK settings EN EL PLUGIN 33
* INSERTAR UN MENU "PARAMETROS FACTURA" EN SETTINGS DE WORDPRESS
  - FORMULARIO 
  - REGISTRO DE CAMPOS O VARIABLES EN LA BASE DE DATOS
  - VALIDACION
  - INPUTS PARA LOS CAMPOS DEL FORMULARIO EN EL FORMULARIO
  - CREAR LOS SHORTCODES
* AÑADIR PAYPAL RECEIVER EN CORREO Y PAGINA DE PEDIDO
* FACTURA A TRES COLUMNAS
* CREAR LA SEGUNDA PAGINA DE LA FACTURA
* WIDGET PAYPAL EN DASHBOARD
* USTIDNR Y MSPARTNER EN EL ENCABEZADO DE FACTURA
* COLOCAR EL TÍTULO DE LA PERSONA EN LA FACTURA
*/
//        load_plugin_textdomain( 'woocommerce-pdf-invoices-packing-slips', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
defined( 'ABSPATH' ) || exit;

// Carga los archivos de traducción del plugin
function wao_tiendas_load_textdomain() {
    load_plugin_textdomain( 'wao-tiendas', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
}
add_action( 'plugins_loaded', 'wao_tiendas_load_textdomain' );

include("wao-link.php");
include("wao-parametros-factura.php");
include("wao-paypal-receiver.php");
include("wao-factura3col.php");
include("wao-2da-pagina-factura.php");
include("paypals/paypal-entry-point.php");
include("mailtraintracking.php");
include("wao-shortcodes.php");
include("wao-banks-widget.php");
include("wao-dailysales-widget.php");
include("wao-contact-support.php");

/////////ARTURO: USTIDNR Y MSPARTNER EN EL ENCABEZADO DE FACTURA
// Incluir NIF en la factura

add_filter( 'wpo_wcpdf_shop_address', 'scodes' );
add_filter( 'wpo_wcpdf_footer', 'scodes',99 );

function scodes($texto){
	$options = get_option('_invoices_options'); //aqui esta la raiz de vertrag y lizenzgeber
	//$texto=str_replace("[ustidnr]",$options["ustidnr"],$texto);
	$texto=str_replace("[ustidnr]",$options["ustidnr"],$texto);
	$texto=str_replace("[mspartner]",$options["mspartner"],$texto);
	$texto=str_replace("[correo]",$options["correo_factura"],$texto);
	$texto=str_replace("[direccion]",$options["direccion_factura"],$texto);
	$texto=str_replace("[direccion2]",$options["direccion2_factura"],$texto);
	$texto=str_replace("[hra]",$options["hra"],$texto);
	$texto=str_replace("[propietario]",$options["propietario"],$texto);
	$texto=str_replace("[nombreshop]",agreganombreshop(),$texto);
	//$texto=str_replace("[nombreshop]",'nose',$texto);
	$texto=str_replace("[direccion]",$options["direccion_factura"],$texto);
	$texto=str_replace("[telefono]",$options["telefono"],$texto);
	$texto=str_replace("[urltienda]",get_option('siteurl'),$texto);
	return $texto;
}
///////FIN DE FUNCION INCLUIR NIF. FUNCION ANULADA, PARA INCLUIR ESTOS DATOS, VASTA COLOCAR SHORTCODES EN LA CONFIGURACION DE PDF INVOICES/General/Shop Addres


//// https://download.winandoffice.com/Install/Plugin%20Arturo/plugin%20Wao%20v2.5.4.zip
//// https://download.winandoffice.com/Install/Plugin%20Arturo/pluginwaoversion.json

add_filter('pre_set_site_transient_update_plugins', 'mi_plugin_check_for_updates');

function mi_plugin_check_for_updates($transient)
{
    if (empty($transient->checked)) {
        return $transient;
    }

    // Cambia la siguiente URL a la URL donde se encuentra el archivo JSON de versión de tu plugin
    $plugin_info_url = 'https://download.winandoffice.com/Install/Plugin%20Arturo/pluginwaoversion.json';

    // Realizar una solicitud HTTP para obtener la información de la última versión
    $response = wp_remote_get($plugin_info_url);

	// Cambia el enlace directo al archivo ZIP de la versión más reciente
	//$plugin_slug = 'https://download.winandoffice.com/Install/Plugin%20Arturo/plugin%20Wao%20v2.5.4.zip';
	$plugin_slug = 'plugin Wao/wao-tiendas.php'; // Reemplaza 'plugin-wao/plugin-wao.php' con el directorio/archivo de tu plugin en WordPress
    $current_version = '';
    $matches = array();
    if (preg_match('/' . preg_quote($plugin_slug) . ' v(\d+\.\d+\.\d+)/i', $transient->checked[$plugin_slug], $matches)) {
        $current_version = $matches[1];
    }

//$current_version = "8.0.0";
    if (!is_wp_error($response) && $response['response']['code'] === 200) {
        $plugin_info = json_decode($response['body']);


        // Compara la versión más reciente con la versión actual del plugin instalado
        if (version_compare($plugin_info->version, $current_version, '>')) {
            $transient->response[$plugin_slug] = $plugin_info;
        }
    }

    return $transient;
}

//add_action('admin_init', 'mi_plugin_debug_output');

function mi_plugin_debug_output() {
    $transient = get_site_transient('update_plugins');
    echo '<pre>';
    print_r($transient);
    echo '</pre>';
}

//////COLOCAR EL TÍTULO DE LA PERSONA EN LA FACTURA
add_action('wpo_wcpdf_before_billing_address','ponertitle',10,2);
function ponertitle($type,$orden){
	$title=get_post_meta($orden->ID,"title");
	if($title<>""){
		echo '<div class="billing-email">'.$title[0].'</div';
	}
}
//////FIN DE COLOCAR EL TÍTULO DE LA PERSONA EN LA FACTURA

//////NOMBRE Y COMPANIA EN FACTURA
add_action('wpo_wcpdf_before_billing_address','compania',10,2);
function compania($tipo,$orden){
	?>
    <span class="custom-text">
    <?php echo "&nbsp;";?>
    </span><br>
    <?php
}

//////FIN DE NOMBRE Y COMPANIA EN FACTURA

///FUNCIONES COMUNES

function tabla($el,$estilo="none"){
	return "<table class='".$estilo."'>".$el."</table>";
}
function tr($el,$estilo="none"){
	return "<tr class='".$estilo."'>".$el."</tr>";
}
function td($el, $estilo="none"){
	return "<td class='".$estilo."'>".$el."</td>";
}
function tag($el,$tipo="b",$estilo="none"){
	return "<".$tipo."  class='".$estilo."'>".$el."</".$tipo.">";
}



?>